package org.msh.tb.reports2.variables;

import org.jboss.seam.international.Messages;
import org.msh.reports.filters.FilterOperation;
import org.msh.reports.filters.FilterOption;
import org.msh.reports.filters.ValueHandler;
import org.msh.reports.keys.Key;
import org.msh.reports.query.SQLDefs;
import org.msh.tb.reports2.VariableImpl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Created by rmemoria on 30/3/17.
 */
public class CasesWithWithoutContactVariable extends VariableImpl {
    public static final String KEY = "contact";
    public static final String KEY_YES = "1";
    public static final String KEY_NO = "2";


    public CasesWithWithoutContactVariable() {
        super(KEY, "manag.reportgen.var.contactsbycases", null);
    }

    @Override
    public int getIteractionCount() {
        return 2;
    }

    @Override
    public void prepareVariableQuery(SQLDefs def, int iteration) {
        String alias = def.getMasterTable().getAlias();

        if (iteration == 0) {
            def.select("1");
            def.addRestriction("exists(select * from tbcontact where case_id = " + alias + ".id)");
        } else {
            def.select("2");
            def.addRestriction("not exists(select * from tbcontact where case_id = " + alias + ".id)");
        }
    }

    @Override
    public String getDisplayText(Key key) {
        Map<String, String> msgs = Messages.instance();

        String val = key.getValue().toString();

        if (KEY_YES.equals(val)) {
            return msgs.get("manag.reportgen.var.contactsbycases.yes");
        }

        if (KEY_NO.equals(val)) {
            return msgs.get("manag.reportgen.var.contactsbycases.no");
        }
        return super.getDisplayText(key);
    }

    @Override
    public void prepareFilterQuery(SQLDefs def, FilterOperation oper, ValueHandler value) {
        // there are just 2 options. If more than 1 is selected, so all cases will be selected
        if (value.isArray()) {
            return;
        }

        String alias = def.getMasterTable().getAlias();

        if (KEY_YES.equals(value.asString())) {
            def.addRestriction("exists(select * from tbcontact where case_id = " + alias + ".id)");
        }

        if (KEY_NO.equals(value.asString())) {
            def.addRestriction("not exists(select * from tbcontact where case_id = " + alias + ".id)");
        }
    }

    @Override
    public List<FilterOption> getFilterOptions(Object param) {
        List<FilterOption> lst = new ArrayList<FilterOption>(2);
        Map<String, String> msgs = Messages.instance();

        lst.add(new FilterOption("1", msgs.get("manag.reportgen.var.contactsbycases.yes")));
        lst.add(new FilterOption("2", msgs.get("manag.reportgen.var.contactsbycases.no")));

        return lst;
    }

    @Override
    public Key createKey(Object values, int iteration) {
        if (values instanceof Integer) {
            return Key.of(values.toString());
        }
        return super.createKey(values, iteration);
    }

    @Override
    public boolean isMultiSelection() {
        return false;
    }
}
